/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category.extras;

import com.jerry.genextras.common.GenExtraLang;
import com.jerry.genextras.common.GeneratorExtraTags;
import com.jerry.genextras.common.registries.GenExtraBlocks;
import com.jerry.genextras.common.registries.GenExtraItems;
import com.jerry.mekextras.MekanismExtras;
import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.MekanismAPI;
import mekanism.common.util.ChemicalUtil;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class NaquadahReactorCategory
extends MultiblockCategory<NaquadahReactor> {
    public NaquadahReactorCategory(IGuiHelper helper) {
        super(helper, MekanismExtras.rl((String)"naquadah_reactor"), NaquadahReactor.class, (Component)GenExtraLang.NAQUADAH_REACTOR.translate(), new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_CONTROLLER));
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_CONTROLLER));
        consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_CASING));
        consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_PORT));
        consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_LOGIC_ADAPTER));
        consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.LEAD_COATED_LASER_FOCUS_MATRIX));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.REACTOR_GLASS));
        List fusionFuelChemicals = MekanismAPI.CHEMICAL_REGISTRY.getTag(GeneratorExtraTags.Chemicals.NAQUADAH_URANIUM_FUEL).stream().flatMap(HolderSet.ListBacked::stream).toList();
        for (Holder chemical : fusionFuelChemicals) {
            consumer.accept(ChemicalUtil.getFilledVariant((ItemStack)new ItemStack((ItemLike)GenExtraItems.NAQUADAH_HOHLRAUM.get()), (Holder)chemical));
        }
    }

    public static class NaquadahReactor
    extends MultiblockWidget {
        protected CheckBoxWidget waterCooledCheckBox;
        protected IntSliderWithButtons portsWidget;
        protected IntSliderWithButtons logicAdaptersWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.waterCooledCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.translatable((String)"text.jei_mekanism_multiblocks.specs.water_cooled"), false);
            consumer.accept((AbstractWidget)this.waterCooledCheckBox);
            this.waterCooledCheckBox.addSelectedChangedHandler(this::onWaterCooledChanged);
            this.portsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.ports", 0, 0, 0);
            consumer.accept(this.portsWidget);
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).addValueChangeHanlder(this::onPortsChanged);
            this.logicAdaptersWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.logic_adapters", 0, 0, 0);
            consumer.accept(this.logicAdaptersWidget);
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).addValueChangeHanlder(this::onLogicAdaptersChanged);
            this.updatePortsSliderLimit();
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.setWaterCooled(tag.getBoolean("WaterCooled"));
            this.setPortCount(tag.getInt("PortCount"));
            this.setLogicAdapterCount(tag.getInt("LogicAdapterCount"));
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.putBoolean("WaterCooled", this.isWaterCooled());
            tag.putInt("PortCount", this.getPortCount());
            tag.putInt("LogicAdapterCount", this.getLogicAdapterCount());
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updatePortsSliderLimit();
        }

        @Override
        public int getCornerBlocks() {
            return 108;
        }

        @Override
        public int getSideBlocks() {
            return 220;
        }

        public void updatePortsSliderLimit() {
            IntSliderWidget portsSlider = (IntSliderWidget)((Object)this.portsWidget.getSlider());
            int minPorts = portsSlider.getMinValue();
            int ports = portsSlider.getValue();
            portsSlider.setMinValue(this.isWaterCooled() ? 4 : 2);
            portsSlider.setMaxValue(this.getSideBlocks());
            portsSlider.setValue(ports + (portsSlider.getMinValue() - minPorts));
            this.updateLogicAdaptersSliderLimit();
        }

        public void updateLogicAdaptersSliderLimit() {
            IntSliderWidget adaptersSlider = (IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider());
            int adapters = adaptersSlider.getValue();
            adaptersSlider.setMaxValue(this.getSideBlocks() - this.getPortCount());
            adaptersSlider.setValue(adapters);
        }

        protected void onPortsChanged(int ports) {
            this.updateLogicAdaptersSliderLimit();
            this.markNeedUpdate();
        }

        protected void onLogicAdaptersChanged(int logicAdapters) {
            this.markNeedUpdate();
        }

        protected void onWaterCooledChanged(boolean waterCooled) {
            this.updatePortsSliderLimit();
            this.markNeedUpdate();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int ports = this.getPortCount();
            sides -= ports;
            int logicAdapter = this.getLogicAdapterCount();
            sides -= logicAdapter;
            int frames = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                frames = corners;
                glasses = sides;
            } else {
                frames = corners + sides;
                glasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_CONTROLLER));
            consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_CASING, frames));
            consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_PORT, ports));
            consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.NAQUADAH_REACTOR_LOGIC_ADAPTER, logicAdapter));
            consumer.accept(new ItemStack((ItemLike)GenExtraBlocks.LEAD_COATED_LASER_FOCUS_MATRIX));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.not_supported"), (Component)Component.literal((String)"-")));
        }

        public int getPortCount() {
            return ((IntSliderWidget)((Object)this.portsWidget.getSlider())).getValue();
        }

        public void setPortCount(int portCount) {
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).setValue(portCount);
        }

        public int getLogicAdapterCount() {
            return ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).getValue();
        }

        public void setLogicAdapterCount(int logicAdapterCount) {
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).setValue(logicAdapterCount);
        }

        public boolean isWaterCooled() {
            return this.waterCooledCheckBox.isSelected();
        }

        public void setWaterCooled(boolean waterCooled) {
            this.waterCooledCheckBox.setSelected(waterCooled);
        }

        @Override
        public int getDimensionWidthMin() {
            return 9;
        }

        @Override
        public int getDimensionWidthMax() {
            return 9;
        }

        @Override
        public int getDimensionLengthMin() {
            return 9;
        }

        @Override
        public int getDimensionLengthMax() {
            return 9;
        }

        @Override
        public int getDimensionHeightMin() {
            return 9;
        }

        @Override
        public int getDimensionHeightMax() {
            return 9;
        }

        @Override
        public Block getGlassBlock() {
            return (Block)GeneratorsBlocks.REACTOR_GLASS.get();
        }
    }
}

