/*
 * Decompiled with CFR 0.152.
 */
package com.limitedchunks.event;

import com.limitedchunks.LimitedChunks;
import com.limitedchunks.config.CommonConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class EventHandler {
    static Map<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>> posToPlayerID = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>>();
    static Map<ResourceKey<Level>, HashMap<UUID, LongSet>> playerIDToPos = new HashMap<ResourceKey<Level>, HashMap<UUID, LongSet>>();
    static Map<ResourceKey<Level>, Queue<ChunkPosAndTime>> unloadQue = new HashMap<ResourceKey<Level>, Queue<ChunkPosAndTime>>();
    public static Set<String> excludedTickets = new HashSet<String>();

    private static Long2ObjectOpenHashMap<UUID> getPosToPlayerIDMap(ResourceKey<Level> worldID) {
        return posToPlayerID.computeIfAbsent(worldID, k -> new Long2ObjectOpenHashMap());
    }

    private static HashMap<UUID, LongSet> getPlayerIDToPosMap(ResourceKey<Level> worldID) {
        return playerIDToPos.computeIfAbsent(worldID, k -> new HashMap());
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        Queue<ChunkPosAndTime> queue = unloadQue.get(world.dimension());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        ChunkPosAndTime current = queue.peek();
        if (current != null && current.time < world.getServer().getNextTickTime()) {
            queue.poll();
            EventHandler.checkLoadedAndClear(current.pos, world);
        }
    }

    private static void checkLoadedAndClear(long pos, ServerLevel world) {
        ServerPlayer player;
        Long2ObjectOpenHashMap<UUID> worldPositionsLoaded = EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.dimension());
        if (!worldPositionsLoaded.containsKey(pos)) {
            return;
        }
        UUID ownerUUID = (UUID)worldPositionsLoaded.get(pos);
        if (ownerUUID != null && (player = world.getServer().getPlayerList().getPlayer(ownerUUID)) != null) {
            return;
        }
        SortedArraySet ticketsE = (SortedArraySet)world.getChunkSource().distanceManager.tickets.get(pos);
        if (ticketsE == null) {
            return;
        }
        ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
        for (Ticket ticket : ticketsE) {
            if (ticket == null) continue;
            if (!excludedTickets.contains(ticket.getType().toString())) {
                if (((CommonConfiguration)LimitedChunks.config.getCommonConfig()).debugLog) {
                    LimitedChunks.LOGGER.info("Unloading ticket:" + ticket.getType().toString() + " at chunkpos:" + String.valueOf(new ChunkPos(pos)));
                }
                ticketsToRemove.add(ticket);
                continue;
            }
            if (ticket.getType() != TicketType.PLAYER) continue;
            ChunkPos chunkPos = new ChunkPos(pos);
            Player closeset = world.getNearestPlayer((double)(chunkPos.x << 4), 0.0, (double)(chunkPos.z << 4), -1.0, null);
            if (closeset == null) continue;
            worldPositionsLoaded.put(pos, (Object)closeset.getUUID());
            return;
        }
        for (Ticket ticket : ticketsToRemove) {
            world.getChunkSource().distanceManager.removeTicket(pos, ticket);
        }
    }

    public static void initDefaultExcludes() {
        excludedTickets = new HashSet<String>();
        excludedTickets.add(TicketType.POST_TELEPORT.toString());
        excludedTickets.add(TicketType.PLAYER.toString());
        excludedTickets.add(TicketType.START.toString());
        excludedTickets.add(TicketType.UNKNOWN.toString());
        excludedTickets.add(TicketType.PORTAL.toString());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        Player closeset = world.getNearestPlayer((double)(event.getChunk().getPos().x << 4), 0.0, (double)(event.getChunk().getPos().z << 4), -1.0, null);
        long pos = event.getChunk().getPos().toLong();
        if (closeset != null) {
            EventHandler.getPlayerIDToPosMap((ResourceKey<Level>)world.dimension()).computeIfAbsent(closeset.getUUID(), k -> new LongOpenHashSet()).add(pos);
            EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.dimension()).put(pos, (Object)closeset.getUUID());
        } else {
            EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.dimension()).put(pos, null);
            Queue quedChunks = unloadQue.computeIfAbsent((ResourceKey<Level>)world.dimension(), s -> new PriorityQueue());
            quedChunks.add(new ChunkPosAndTime(pos, world.getServer().getNextTickTime() + (long)(((CommonConfiguration)LimitedChunks.config.getCommonConfig()).chunkunloadnoplayer * 1000 * 60)));
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        Set positions;
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        long pos = event.getChunk().getPos().toLong();
        UUID playerID = (UUID)EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.dimension()).remove(pos);
        if (playerID != null && (positions = (Set)EventHandler.getPlayerIDToPosMap((ResourceKey<Level>)world.dimension()).get(playerID)) != null) {
            positions.remove(pos);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getEntity().level();
        for (Map.Entry<ResourceKey<Level>, HashMap<UUID, LongSet>> dimEntry : playerIDToPos.entrySet()) {
            LongSet chunksFromPlayer;
            HashMap<UUID, LongSet> playerToPosMap = dimEntry.getValue();
            if (playerToPosMap == null || (chunksFromPlayer = playerToPosMap.remove(event.getEntity().getUUID())) == null) continue;
            Queue quedChunks = unloadQue.computeIfAbsent(dimEntry.getKey(), s -> new PriorityQueue());
            LongIterator longIterator = chunksFromPlayer.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                quedChunks.add(new ChunkPosAndTime(pos, world.getServer().getNextTickTime() + (long)(((CommonConfiguration)LimitedChunks.config.getCommonConfig()).chunkunloadnoplayer * 1000 * 60)));
            }
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        posToPlayerID = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>>();
        playerIDToPos = new HashMap<ResourceKey<Level>, HashMap<UUID, LongSet>>();
        unloadQue = new HashMap<ResourceKey<Level>, Queue<ChunkPosAndTime>>();
    }

    private static class ChunkPosAndTime
    implements Comparable<ChunkPosAndTime> {
        final long pos;
        final long time;

        ChunkPosAndTime(long pos, long time) {
            this.pos = pos;
            this.time = time;
        }

        @Override
        public int compareTo(ChunkPosAndTime o) {
            return (int)(this.time - o.time);
        }
    }
}

