/*
 * Decompiled with CFR 0.152.
 */
package com.limitedchunks;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"limitedchunks").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"listActiveTickets").then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos pos = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            ChunkPos chunkPos = new ChunkPos(pos);
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            level.getChunkSource().distanceManager.runAllUpdates(level.getChunkSource().chunkMap);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Chunk tickets at: " + pos.toShortString())));
            SortedArraySet tickets = (SortedArraySet)level.getChunkSource().distanceManager.tickets.get(chunkPos.toLong());
            if (tickets == null || tickets.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"None").withStyle(ChatFormatting.YELLOW));
                return 1;
            }
            for (Ticket ticket : tickets) {
                if (ticket == null) continue;
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)ticket.toString()).withStyle(ChatFormatting.YELLOW));
            }
            return 1;
        })))).then(Commands.literal((String)"listnonplayerchunktickets").executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            level.getChunkSource().distanceManager.runAllUpdates(level.getChunkSource().chunkMap);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Listing all chunks and their tickets, which are not near a player: "));
            int count = 0;
            for (Long2ObjectMap.Entry entry : level.getChunkSource().distanceManager.tickets.long2ObjectEntrySet()) {
                if (entry.getValue() == null) continue;
                boolean hasPLayer = false;
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null || ticket.getType() != TicketType.PLAYER) continue;
                    hasPLayer = true;
                    break;
                }
                if (hasPLayer) continue;
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Chunk tickets at:" + String.valueOf(new ChunkPos(entry.getLongKey()).getWorldPosition()))));
                ++count;
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null) continue;
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)ticket.toString()).withStyle(ChatFormatting.YELLOW));
                }
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Total amount: " + count)));
            return 1;
        }));
    }
}

