/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.mods_downloader.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;

public class Modrinth {
    private static final String BASE_URL = "https://api.modrinth.com/v2";
    private static final String USER_AGENT = "CrashAssistant/1.0";
    private static final Gson GSON = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, VersionFileInfo> lookupVersionFiles(Collection<String> sha1Hashes) throws IOException {
        HashMap<String, VersionFileInfo> result = new HashMap<String, VersionFileInfo>();
        if (sha1Hashes == null || sha1Hashes.isEmpty()) {
            return result;
        }
        LinkedHashSet<String> deduped = new LinkedHashSet<String>();
        for (String hash : sha1Hashes) {
            if (hash == null || hash.trim().isEmpty()) continue;
            deduped.add(hash.toLowerCase(Locale.ROOT));
        }
        if (deduped.isEmpty()) {
            return result;
        }
        HttpURLConnection connection = null;
        try {
            URL url = new URL("https://api.modrinth.com/v2/version_files");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setDoOutput(true);
            connection.setConnectTimeout(8000);
            connection.setReadTimeout(20000);
            JsonObject payload = new JsonObject();
            JsonArray hashesArray = new JsonArray();
            for (String hash : deduped) {
                hashesArray.add(hash);
            }
            payload.add("hashes", (JsonElement)hashesArray);
            payload.addProperty("algorithm", "sha1");
            byte[] body = payload.toString().getBytes(StandardCharsets.UTF_8);
            try (OutputStream os = connection.getOutputStream();){
                os.write(body);
            }
            int code = connection.getResponseCode();
            if (code != 200) {
                CrashAssistantApp.LOGGER.warn("Modrinth lookup failed with HTTP {}", (Object)code);
                HashMap<String, VersionFileInfo> hashMap = result;
                return hashMap;
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            JsonObject response = (JsonObject)GSON.fromJson(sb.toString(), JsonObject.class);
            for (Map.Entry entry : response.entrySet()) {
                String hash;
                String string = hash = entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                if (hash == null) continue;
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                String projectId = Modrinth.getAsString(obj, "project_id");
                String versionId = Modrinth.getAsString(obj, "id");
                String projectUrl = projectId == null ? null : "https://modrinth.com/mod/" + projectId;
                String downloadUrl = null;
                String fileName = null;
                if (obj.has("files") && obj.get("files").isJsonArray()) {
                    JsonArray files = obj.getAsJsonArray("files");
                    JsonObject preferred = null;
                    for (JsonElement fileElement : files) {
                        JsonObject fileObj = fileElement.getAsJsonObject();
                        if (!fileObj.has("primary") || !fileObj.get("primary").getAsBoolean()) continue;
                        preferred = fileObj;
                        break;
                    }
                    if (preferred == null && files.size() > 0) {
                        preferred = files.get(0).getAsJsonObject();
                    }
                    if (preferred != null) {
                        downloadUrl = Modrinth.getAsString(preferred, "url");
                        if (preferred.has("filename")) {
                            fileName = preferred.get("filename").getAsString();
                        }
                    }
                }
                result.put(hash, new VersionFileInfo(hash, projectId, versionId, fileName, downloadUrl, projectUrl));
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to query Modrinth version_files API", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    private static String getAsString(JsonObject obj, String key) {
        if (obj == null || key == null || !obj.has(key) || obj.get(key).isJsonNull()) {
            return null;
        }
        try {
            return obj.get(key).getAsString();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static class VersionFileInfo {
        public final String hash;
        public final String projectId;
        public final String versionId;
        public final String fileName;
        public final String downloadUrl;
        public final String projectUrl;

        public VersionFileInfo(String hash, String projectId, String versionId, String fileName, String downloadUrl, String projectUrl) {
            this.hash = hash;
            this.projectId = projectId;
            this.versionId = versionId;
            this.fileName = fileName;
            this.downloadUrl = downloadUrl;
            this.projectUrl = projectUrl;
        }
    }
}

