/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils.gpu;

import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.utils.gpu.GPU;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ErrorUtils;
import java.lang.reflect.Method;
import java.util.List;

public class GPUDetector {
    public static String getSerialisedGPUs() {
        List<GPU> gpus;
        Method getSerialisedGPUsMethod;
        Object serialisedGPUs = "";
        boolean vulkanSuccess = false;
        try {
            if (Boot.vulkanAddonLoaded) {
                Class<?> vulkanDetectorClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.utils.gpu.VulkanGPUDetector");
                getSerialisedGPUsMethod = vulkanDetectorClass.getMethod("getSerialisedGPUs", new Class[0]);
                String vulkanResult = (String)getSerialisedGPUsMethod.invoke(null, new Object[0]);
                gpus = GPU.deserializeGPUs(vulkanResult);
                if (gpus != null && !gpus.isEmpty()) {
                    serialisedGPUs = (String)serialisedGPUs + "Successfully detected GPUs using Vulkan:\n";
                    serialisedGPUs = (String)serialisedGPUs + vulkanResult;
                    vulkanSuccess = true;
                } else {
                    serialisedGPUs = (String)serialisedGPUs + "Vulkan detection returned empty result, falling back to DirectX\n";
                    if (!vulkanResult.trim().isEmpty()) {
                        serialisedGPUs = (String)serialisedGPUs + vulkanResult;
                    }
                }
            } else {
                serialisedGPUs = (String)serialisedGPUs + "Vulkan GPU detection addon not found, falling back to DirectX\n";
            }
        }
        catch (Exception e) {
            serialisedGPUs = (String)serialisedGPUs + "Error during Vulkan GPU detection:\n" + ErrorUtils.getErrorMessageAndStackTrace((Throwable)e) + "\nFalling back to DirectX.\n";
        }
        if (!vulkanSuccess) {
            if (PlatformHelp.isWindows()) {
                try {
                    Class<?> directXDetectorClass = Class.forName("dev.kostromdan.mods.crash_assistant.app.utils.gpu.DirectXGPUDetector");
                    getSerialisedGPUsMethod = directXDetectorClass.getMethod("getSerialisedGPUs", new Class[0]);
                    String directXResult = (String)getSerialisedGPUsMethod.invoke(null, new Object[0]);
                    gpus = GPU.deserializeGPUs(directXResult);
                    if (gpus != null && !gpus.isEmpty()) {
                        serialisedGPUs = (String)serialisedGPUs + "Successfully detected GPUs using DirectX:\n";
                        serialisedGPUs = (String)serialisedGPUs + directXResult;
                    } else {
                        serialisedGPUs = (String)serialisedGPUs + "DirectX detection returned empty result, this shouldn't happen on modern versions of Windows.\n";
                        if (!directXResult.trim().isEmpty()) {
                            serialisedGPUs = (String)serialisedGPUs + directXResult;
                        }
                    }
                }
                catch (Exception e) {
                    serialisedGPUs = (String)serialisedGPUs + "Error during DirectX GPU detection:\n" + ErrorUtils.getErrorMessageAndStackTrace((Throwable)e) + "\n";
                }
            } else {
                serialisedGPUs = (String)serialisedGPUs + "DirectX GPU detection is not supported on non-Windows platforms\nIf you want Minecraft running of integrated GPU while dedicated GPU exists warning feature work on your pc,\npls install our addon with Vulkan lib (Crash Assistant cross platform integrated GPU detection addon).";
            }
        }
        return serialisedGPUs;
    }

    public static void main(String[] args) {
        String serialized = GPUDetector.getSerialisedGPUs();
        System.out.println(serialized);
        List<GPU> gpus = GPU.deserializeGPUs(serialized);
        System.out.println(gpus);
    }
}

