/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import java.io.File;
import java.util.Arrays;

public class WinEventCleaner {
    public static void cleanOldWinEventFiles() {
        File dir = new File(".");
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalStateException("Root directory is not accessible.");
        }
        File[] eventFiles = dir.listFiles((d, name) -> name.matches("win_event\\d+\\.txt"));
        if (eventFiles == null || eventFiles.length <= 5) {
            return;
        }
        Arrays.sort(eventFiles, (f1, f2) -> {
            long num1 = WinEventCleaner.extractNumber(f1.getName());
            long num2 = WinEventCleaner.extractNumber(f2.getName());
            return Long.compare(num1, num2);
        });
        int filesToDelete = eventFiles.length - 5;
        for (int i = 0; i < filesToDelete; ++i) {
            if (eventFiles[i].delete()) continue;
            System.err.println("Failed to delete file: " + eventFiles[i].getAbsolutePath());
        }
    }

    private static long extractNumber(String fileName) {
        String numericPart = fileName.replace("win_event", "").replace(".txt", "");
        return Long.parseLong(numericPart);
    }
}

