/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DragAndDrop {
    public static void enableDragAndDrop(JComponent fileNameLabel, final List<File> files) {
        fileNameLabel.setTransferHandler(new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new FileTransferable(files);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        fileNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ControlPanel.stopMovingToTop = true;
                JComponent component = (JComponent)e.getSource();
                TransferHandler handler = component.getTransferHandler();
                handler.exportAsDrag(component, e, 1);
            }
        });
    }

    private static class FileTransferable
    implements Transferable {
        private final List<File> files;

        public FileTransferable(List<File> files) {
            this.files = files;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return this.files;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

