/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.modlist;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.utils.LinksHelper;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModFingerprinter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;

public class ManualDownloadDialog
extends JDialog {
    private final Path downloadsDir;
    private final Path targetDir;
    private final String expectedFileName;
    private final HashSet<Long> expectedCfHashes;
    private final HashSet<String> expectedMrHashes;
    private final String downloadPageUrl;
    private final JLabel statusLabel = new JLabel();
    private volatile boolean completed = false;
    private volatile boolean skipped = false;

    public ManualDownloadDialog(Window owner, String expectedFileName, Path targetDir, String downloadPageUrl, HashSet<Long> expectedCfHashes, HashSet<String> expectedMrHashes) {
        super(owner, LanguageProvider.get((String)"gui.modlist_diff.manual_download.title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.expectedFileName = expectedFileName;
        this.targetDir = targetDir;
        this.downloadPageUrl = downloadPageUrl;
        this.expectedCfHashes = expectedCfHashes;
        this.expectedMrHashes = expectedMrHashes;
        this.downloadsDir = Paths.get(System.getProperty("user.home", ""), "Downloads");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ManualDownloadDialog.this.skipped = true;
                ManualDownloadDialog.this.setVisible(false);
            }
        });
        this.buildUi();
        this.startWatcherThread();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void buildUi() {
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(new EmptyBorder(12, 12, 12, 12));
        JTextArea message = new JTextArea(LanguageProvider.get((String)"gui.modlist_diff.manual_download.message").replace("$FILE$", this.expectedFileName));
        message.setEditable(false);
        message.setLineWrap(true);
        message.setWrapStyleWord(true);
        message.setBackground(root.getBackground());
        message.setBorder(new EmptyBorder(0, 0, 8, 0));
        root.add((Component)message, "North");
        JPanel dropPanel = new JPanel(new BorderLayout());
        dropPanel.setBorder(BorderFactory.createDashedBorder(Color.GRAY));
        dropPanel.setBackground(new Color(245, 245, 245));
        JLabel dropLabel = new JLabel(LanguageProvider.get((String)"gui.modlist_diff.manual_download.drag_drop"), 0);
        dropLabel.setBorder(new EmptyBorder(12, 12, 12, 12));
        dropPanel.add((Component)dropLabel, "Center");
        dropPanel.setPreferredSize(new Dimension(360, 140));
        root.add((Component)dropPanel, "Center");
        dropPanel.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    Transferable t = support.getTransferable();
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (files.isEmpty()) {
                        return false;
                    }
                    Path candidate = ((File)files.get(0)).toPath();
                    return ManualDownloadDialog.this.handleCandidate(candidate, false);
                }
                catch (Exception ex) {
                    CrashAssistantApp.LOGGER.error("Failed to process dropped file", (Throwable)ex);
                    return false;
                }
            }
        });
        this.statusLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.manual_download.waiting").replace("$FILE$", this.expectedFileName));
        this.statusLabel.setBorder(new EmptyBorder(10, 0, 6, 0));
        JPanel buttons = new JPanel(new FlowLayout(2));
        if (this.downloadPageUrl != null) {
            JButton openPage = new JButton(LanguageProvider.get((String)"gui.modlist_diff.manual_download.open_page"));
            openPage.addActionListener(this::openPage);
            buttons.add(openPage);
        }
        JButton skip = new JButton(LanguageProvider.get((String)"gui.modlist_diff.manual_download.skip"));
        skip.addActionListener(e -> {
            this.skipped = true;
            this.completed = false;
            this.setVisible(false);
        });
        buttons.add(skip);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)this.statusLabel, "Center");
        bottom.add((Component)buttons, "South");
        root.add((Component)bottom, "South");
        this.setContentPane(root);
    }

    private void openPage(ActionEvent e) {
        try {
            if (Desktop.isDesktopSupported()) {
                LinksHelper.browse(URI.create(this.downloadPageUrl));
            }
        }
        catch (Exception ex) {
            CrashAssistantApp.LOGGER.error("Failed to open download page {}", (Object)this.downloadPageUrl, (Object)ex);
        }
    }

    private void startWatcherThread() {
        Thread t = new Thread(() -> {
            while (!this.completed && !this.skipped) {
                try {
                    if (this.isVisible()) {
                        this.checkDownloadsDir();
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
        }, "manual-download-watcher");
        t.setDaemon(true);
        t.start();
    }

    private void checkDownloadsDir() {
        try {
            Path candidate;
            if (this.downloadsDir != null && Files.exists(candidate = this.downloadsDir.resolve(this.expectedFileName), new LinkOption[0]) && this.handleCandidate(candidate, true)) {
                return;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Failed to monitor downloads folder", (Throwable)e);
        }
    }

    private boolean tryMoveCandidate(Path candidate) {
        try {
            if (!Files.exists(candidate, new LinkOption[0])) {
                return false;
            }
            Files.createDirectories(this.targetDir, new FileAttribute[0]);
            Path target = this.targetDir.resolve(this.expectedFileName);
            Files.move(candidate, target, StandardCopyOption.REPLACE_EXISTING);
            this.completed = true;
            SwingUtilities.invokeLater(() -> {
                this.statusLabel.setText(LanguageProvider.get((String)"gui.modlist_diff.manual_download.done"));
                this.setVisible(false);
            });
            return true;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to move downloaded file {}", (Object)candidate, (Object)e);
            return false;
        }
    }

    private ModFingerprinter.IdentificationResult fingerprint(Path candidate) {
        try {
            return ModFingerprinter.identify((Path)candidate);
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to fingerprint {}", (Object)candidate, (Object)e);
            return null;
        }
    }

    private boolean hashesMatch(ModFingerprinter.IdentificationResult fp) {
        if (fp == null) {
            return false;
        }
        boolean cfOk = this.expectedCfHashes != null && this.expectedCfHashes.contains(fp.getCurseForgeHash());
        boolean mrOk = this.expectedMrHashes != null && this.expectedMrHashes.contains(fp.getModrinthHash());
        return cfOk || mrOk;
    }

    private boolean handleCandidate(Path candidate, boolean fromWatcher) {
        try {
            if (!Files.exists(candidate, new LinkOption[0])) {
                return false;
            }
            boolean nameMatches = candidate.getFileName().toString().equals(this.expectedFileName);
            ModFingerprinter.IdentificationResult fp = this.fingerprint(candidate);
            boolean hashOk = this.hashesMatch(fp);
            if (hashOk) {
                return this.tryMoveCandidate(candidate);
            }
            if (!nameMatches && fromWatcher) {
                return false;
            }
            String msg = LanguageProvider.get((String)"gui.modlist_diff.manual_download.hash_mismatch_warning").replace("$FILE$", candidate.getFileName().toString()).replace("$EXPECTED$", this.expectedFileName);
            int choice = JOptionPane.showConfirmDialog(this, msg, LanguageProvider.get((String)"gui.modlist_diff_dialog_name"), 0, 2);
            if (choice == 0) {
                return this.tryMoveCandidate(candidate);
            }
            return false;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to handle candidate {}", (Object)candidate, (Object)e);
            return false;
        }
    }

    public boolean awaitResult() {
        this.setVisible(true);
        return this.completed && !this.skipped;
    }
}

