/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis;

import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MCreatorModDetectorGUI
extends AnalysisGUIBase {
    public MCreatorModDetectorGUI(JFrame parent) {
        super(parent, LanguageProvider.get((String)"gui.menu.analysis.mcreator_mod_detector"), LanguageProvider.get((String)"gui.analysis.mcreator_detector.header"));
    }

    public static void showMCreatorModDetectorDialog(JFrame parent) {
        new MCreatorModDetectorGUI(parent).start();
    }

    @Override
    protected void performAnalysis() {
        LinkedHashSet modsToAnalyze = ModListUtils.getCurrentModList((boolean)true);
        int totalMods = modsToAnalyze.size();
        AtomicInteger completedTasks = new AtomicInteger(0);
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(totalMods));
        ArrayList mcreatorMods = new ArrayList();
        for (Mod mod : modsToAnalyze) {
            executor.submit(() -> {
                if (isCancelled) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + mod.getJarName()));
                if (Boolean.TRUE.equals(mod.IsMCreator())) {
                    mcreatorMods.add(mod);
                    this.registerDetectedModJar(mod.getJarName());
                }
                int completed = completedTasks.incrementAndGet();
                SwingUtilities.invokeLater(() -> {
                    if (!isCancelled) {
                        this.progressBar.setValue(completed);
                    }
                });
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled) {
            SwingUtilities.invokeLater(() -> {
                if (mcreatorMods.isEmpty()) {
                    this.appendStyledText(LanguageProvider.get((String)"gui.analysis.mcreator_detector.no_mods"), NORMAL_COLOR);
                } else {
                    String msg = LanguageProvider.get((String)"gui.analysis.mcreator_detector.found").replace("$COUNT$", String.valueOf(mcreatorMods.size()));
                    this.appendStyledText(msg, NORMAL_COLOR);
                    for (Mod mod : mcreatorMods) {
                        this.appendStyledText(mod.getJarName() + "\n", MOD_COLOR);
                    }
                }
            });
        }
    }

    @Override
    protected String getWhyButtonTextKey() {
        return "gui.analysis.mcreator_detector.why_button";
    }

    @Override
    protected String getWhyDialogTitleKey() {
        return "gui.analysis.mcreator_detector.about_title";
    }

    @Override
    protected String getWhyDialogBodyKey() {
        return "gui.analysis.mcreator_detector.why_info";
    }

    @Override
    protected int getWhyDialogWidth() {
        return 500;
    }
}

