/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PrivacyPolicyDialog {
    private static boolean acceptedForCurrentLaunch = false;

    public static boolean showPrivacyPolicyDialog() {
        if (Objects.equals(CrashAssistantLocalConfig.get((String)"privacy.accepted_privacy_info"), LanguageProvider.get((String)"gui.privacy.crash_assistant_privacy_policy.version"))) {
            return true;
        }
        if (acceptedForCurrentLaunch) {
            return true;
        }
        if (!CrashAssistantConfig.getBoolean((String)"general.enable_privacy_policy_acceptance")) {
            return true;
        }
        JFrame ownerFrame = CrashAssistantGUI.getFrame();
        JDialog dialog = new JDialog(ownerFrame, LanguageProvider.get((String)"gui.privacy.logs_upload_title"), true);
        dialog.setDefaultCloseOperation(2);
        Object question = CrashAssistantLocalConfig.get((String)"privacy.accepted_privacy_info") == null ? "" : LanguageProvider.get((String)"gui.privacy.logs_upload_question_changed") + "\n";
        question = (String)question + LanguageProvider.get((String)"gui.privacy.logs_upload_question", (HashMap)new HashMap<String, String>(){
            {
                this.put("$LINK.PRIVACY_POLICY$", LanguageProvider.get((String)"gui.privacy.privacy_policy"));
            }
        });
        JEditorPane editorPane = CrashAssistantGUI.getEditorPane((String)question, true);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)editorPane, "Center");
        JCheckBox rememberMyChoiceCheck = new JCheckBox(LanguageProvider.get((String)"gui.privacy.remember_my_choice"));
        rememberMyChoiceCheck.setSelected(true);
        JButton acceptButton = new JButton(LanguageProvider.get((String)"gui.privacy.logs_upload_accept"));
        acceptButton.setForeground(Color.GREEN.darker());
        acceptButton.setFont(acceptButton.getFont().deriveFont(1));
        JButton declineButton = new JButton(LanguageProvider.get((String)"gui.privacy.logs_upload_decline"));
        declineButton.setForeground(Color.RED);
        declineButton.setFont(declineButton.getFont().deriveFont(1));
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 10));
        buttonPanel.add(rememberMyChoiceCheck);
        buttonPanel.add(acceptButton);
        buttonPanel.add(declineButton);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)textPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        dialog.setContentPane(mainPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(ownerFrame);
        dialog.setResizable(false);
        boolean[] result = new boolean[]{false};
        acceptButton.addActionListener(e -> {
            if (rememberMyChoiceCheck.isSelected()) {
                CrashAssistantLocalConfig.set((String)"privacy.accepted_privacy_info", (Object)LanguageProvider.get((String)"gui.privacy.crash_assistant_privacy_policy.version"));
                CrashAssistantApp.LOGGER.info("User accepted privacy policy.");
            } else {
                acceptedForCurrentLaunch = true;
                CrashAssistantApp.LOGGER.info("User accepted privacy policy (without checking \"Remember my choice\" checkbox).");
            }
            result[0] = true;
            dialog.dispose();
        });
        declineButton.addActionListener(e -> {
            result[0] = false;
            dialog.dispose();
        });
        dialog.setVisible(true);
        return result[0];
    }

    public static void resetPrivacyConsent() {
        boolean changesApplied = false;
        if (CrashAssistantLocalConfig.get((String)"privacy.accepted_privacy_info") != null) {
            CrashAssistantLocalConfig.set((String)"privacy.accepted_privacy_info", null);
            changesApplied = true;
        }
        if (acceptedForCurrentLaunch) {
            acceptedForCurrentLaunch = false;
            changesApplied = true;
        }
        if (!CrashAssistantConfig.getBoolean((String)"general.enable_privacy_policy_acceptance")) {
            CrashAssistantConfig.set((String)"general.enable_privacy_policy_acceptance", (Object)true);
            changesApplied = true;
        }
        JFrame ownerFrame = CrashAssistantGUI.getFrame();
        if (changesApplied) {
            JOptionPane.showMessageDialog(ownerFrame, LanguageProvider.get((String)"gui.privacy.consent_reset_success"), LanguageProvider.get((String)"gui.privacy.title"), 1);
        } else {
            JOptionPane.showMessageDialog(ownerFrame, LanguageProvider.get((String)"gui.privacy.consent_not_given"), LanguageProvider.get((String)"gui.privacy.title"), 1);
        }
    }
}

