/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.common_config.config.ProblematicModsConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IncompatibleModsWarning {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWarnings(Component parent) {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                List currentProblematicMods = ProblematicModsConfig.getCurrentProblematicMods();
                SwingUtilities.invokeAndWait(() -> {
                    for (ProblematicModsConfig.ProblematicMod problematicMod : currentProblematicMods) {
                        ControlPanel.stopMovingToTop = true;
                        CrashAssistantApp.LOGGER.info("Showing IncompatibleModsWarning about {}", (Object)problematicMod.getCurrentMod().getJarName());
                        Object[] options = new String[]{LanguageProvider.get((String)"gui.remove_mod"), LanguageProvider.get((String)"gui.disable_mod"), LanguageProvider.get((String)"gui.show_in_explorer_button"), LanguageProvider.get((String)"gui.ok")};
                        int choice = JOptionPane.showOptionDialog(parent, CrashAssistantGUI.getEditorPane(problematicMod.getMsg().replaceAll("\\$JAR_NAME\\$", problematicMod.getCurrentMod().getJarName()), true, 600), LanguageProvider.get((String)"gui.incompatible_mod"), -1, 2, null, options, options[3]);
                        File file = ModListUtils.MODS_FOLDER.resolve(problematicMod.getCurrentMod().getJarName()).toFile();
                        if (choice == 0) {
                            try {
                                Files.delete(file.toPath());
                            }
                            catch (NoSuchFileException noSuchFileException) {
                            }
                            catch (Exception e) {
                                CrashAssistantApp.LOGGER.error("Failed to remove mod: ", (Throwable)e);
                                JOptionPane.showMessageDialog(parent, String.format(LanguageProvider.get((String)"gui.error_delete_mod_exception"), e), "Error", 0);
                            }
                        } else if (choice == 1) {
                            File disabledFile = new File(file.getParent(), file.getName() + ".disabled");
                            try {
                                Files.move(file.toPath(), disabledFile.toPath(), new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                file.delete();
                            }
                            catch (IOException e) {
                                CrashAssistantApp.LOGGER.error("Failed to disable mod: ", (Throwable)e);
                                JOptionPane.showMessageDialog(parent, String.format(LanguageProvider.get((String)"gui.error_disable_mod_exception"), e), "Error", 0);
                            }
                        } else if (choice == 2) {
                            try {
                                if (System.getProperty("os.name").startsWith("Windows")) {
                                    new ProcessBuilder("explorer.exe", "/select,", file.toPath().toAbsolutePath().toString()).start();
                                } else {
                                    Desktop.getDesktop().open(file.getParentFile());
                                }
                            }
                            catch (Exception e) {
                                CrashAssistantApp.LOGGER.error("Failed to show file in explorer: ", (Throwable)e);
                                JOptionPane.showMessageDialog(parent, String.format(LanguageProvider.get((String)"gui.error_open_explorer"), e), "Error", 0);
                            }
                        }
                        CrashAssistantApp.LOGGER.info("Shown IncompatibleModsWarning about {}", (Object)problematicMod.getCurrentMod().getJarName());
                    }
                });
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing incompatible mods warnings: ", (Throwable)e);
            }
            return;
        }
    }
}

